#!/usr/bin/env python

from xml.dom.ext.reader.Sax import FromXmlFile, FromXml # parse XML
from xml.sax import saxutils

from objects import *

class XmlReader:
    def __init__(self, with_filename):
        self.filename = with_filename
    
    def fatal(self, message):
        print "[E] %s : %s" % (self.filename, message)
        return None
    
    def parse_string(self, content):
        try:
            document = FromXml(content)
        except StandardError, reason:
            return self.fatal(reason)
        metalib = self.parse_document(document)
        self.filename = "%s.xml" % metalib.id
        return metalib
    
    def parse_as_metalib(self):
        document = None
        try:
            document = FromXmlFile(self.filename)
        except StandardError, reason:
            return self.fatal(reason)
            
        return self.parse_document(document)

    def parse_document(self, document):
        # getting <metalib>
        if len(document.getElementsByTagName("metalib")) != 1:
            return self.fatal("Invalid file structure, tag <metalib> must be present and unique")
        metalib_tag = document.getElementsByTagName("metalib")[0]
        metalib = MetaLib(with_id = metalib_tag.getAttribute("id"), with_definition = None, with_medias = {})
        if metalib_tag.getAttribute("is_locked") == "yes" :
            metalib.is_locked = True
        else:
            metalib.is_locked = False
            
        # getting <defintion>
        if len(metalib_tag.getElementsByTagName("definition")) != 1:
            return self.fatal("Invalid file structure, tag <definition> must be present and unique in childs of <metalib>")
        definition_tag = metalib_tag.getElementsByTagName("definition")[0]
        definition_key = definition_tag.getAttribute("key")
        if definition_key == "" :
            return self.fatal("Attribute 'key' is missing on tag <definition>")

        definition = Definition(with_key = definition_key, with_data_definitions = {})
        metalib.definition = definition

        # getting each <data> of <definition>
        for data_tag in definition_tag.getElementsByTagName("data"):
            data_definition = None
            data_definition = self.parse_data_definition(data_tag)
            if data_definition is None:
                return
            definition.add_data_definition(data_definition)

        # getting <content>
        if len(metalib_tag.getElementsByTagName("content")) != 1:
            return self.fatal("Invalid file structure, tag <content> must be present and unique in childs of <metalib>")
        content_tag = metalib_tag.getElementsByTagName("content")[0]
        
        # getting each <media>
        for media_tag in content_tag.getElementsByTagName("media"):
            media = self.parse_media(media_tag, definition)
            if media is None:
                return
            metalib.add_media(media)
        return metalib

    def parse_data_definition(self, data_tag):
        id = data_tag.getAttribute("id")
        if id == "":
            return self.fatal("Attribute 'id' is missing on tag <definition><data>")
        data_definition = DataDefinition(with_id = id)
        data_definition.type = data_tag.getAttribute("type")
        data_definition.display = data_tag.getAttribute("display")
        
        if len(data_tag.getElementsByTagName("comment")) == 1:
            try:
                data_definition.comment = data_tag.getElementsByTagName("comment")[0].firstChild.data
            except StandardError, reason:
                return self.fatal("tag <comment> must have data text")

        data_definition = data_definition.compile()
        if not data_definition.is_simple():
            sub_filename = data_definition.metalib_filename()
            data_definition.metalib = XmlReader(sub_filename).parse_as_metalib()
        
        return data_definition
        
    def parse_media(self, media_tag, definition):
        media = Media(definition, with_data = {})
        for data_tag in media_tag.getElementsByTagName("data"):
            if data_tag.getAttribute("id") == "":
                self.fatal("Attribute 'id' is missing on tag <content><media><data>")
            data_id = data_tag.getAttribute("id")
            data = Data(with_id = data_id, with_definition = definition.data_definitions[data_id])
            try:
                data.value = data_tag.firstChild.data
            except StandardError, reason:
                return self.fatal("tag <data> must have data text")

            media.add_data(data)
        return media


