from xml.dom.minidom import parseString

import re, new

class Tag_definition:
    def __init__(self, with_name, with_class):
        self.attributes = {}
        self.name = with_name
        self.tag_class = with_class

class Tag_attribute:
    def __init__(self, with_name, wich_is_required):
        self.name = with_name
        if (wich_is_required.upper() == "YES") or (wich_is_required.upper() == "TRUE") :
            self.is_required = True
        else:
            self.is_required = False
        self.check = ".*"
        
class Tag:
    SKIP_BODY = "SKIP_BODY"
    EVAL_BODY_AGAIN = "EVAL_BODY_AGAIN"
    EVAL_BODY_INCLUDE = "EVAL_BODY_INCLUDE"

    def new_instance_for_elememt(self, element):
        if element.tagName.find(":") == -1:
            return None
        taglib_name = element.tagName[:element.tagName.find(":")]
        if not self.page_context.taglib.has_key(taglib_name):
            print "No mapping found for taglib %s" % taglib_name
            return
        tag_name = element.tagName[element.tagName.find(":")+1:]
        if not self.page_context.taglib[taglib_name].has_key(tag_name):
            print "No mapping found for tag %s:%s" % (taglib_name, tag_name)
            return
        tag_definition = self.page_context.taglib[taglib_name][tag_name]
        tag = new.instance(tag_definition.tag_class)
        tag.__init__(tag_definition)
        tag.page_context = self.page_context
        tag.set_xml_element(element)
        tag.parent = self
        return tag
    
    def __init__(self, tag_definition):
        self.definition = tag_definition
        self.page_context = None
        self.attributes = {}
        self.xml_element = None
        self.inner_html = ""
        self.parent = None
    
    def set_xml_element(self, element):
        self.xml_element = element
        for (attribute_name, attribute) in self.definition.attributes.items():
            attribute_value = element.getAttribute(attribute_name)
            if (attribute_value == "") and (attribute.is_required):
                print "Attribute '%s' is empty but required in tag <%s>." % (attribute_name, element.tagName)
                continue
            if (attribute_value != "") and not re.compile(attribute.check).match(attribute_value):
                print "Attribute '%s' does not match with '%s'." % (attribute_value, attribute.check)
                continue
            self.attributes[attribute_name] = attribute_value
            
    def get_html(self, out_stream):
        val = self.do_start_tag(out_stream)
        while True:
            if val == self.SKIP_BODY:
                new_val = self.do_end_tag(out_stream)
                if new_val == self.SKIP_BODY:
                    return
                else:
                    print "ERREUR"
                    return
            # evaluer le HTML dans le tag:
            self.do_body(out_stream)

            val = self.do_after_body(out_stream)
            if val == self.SKIP_BODY:
                new_val = self.do_end_tag(out_stream)
                if new_val == self.SKIP_BODY:
                    return
                else:
                    print "ERREUR"
                    return
            elif val == self.EVAL_BODY_INCLUDE:
                print "ERREUR"
                return
            elif val == self.EVAL_BODY_AGAIN:
                # recommencer la boucle:
                pass

    def do_start_tag(self, out_stream):
        #out_stream.write("<!-- %s.do_start_tag -->\n" % self.__class__)
        return self.EVAL_BODY_INCLUDE


    def render_sub_tag(self, element, out_stream):
        result = ""
        print element.childNodes
        for child_tag in element.childNodes:
            # see http://www.astro.rug.nl/~gipsy/pydoc/xml.dom.html#Node
            if child_tag.nodeType == child_tag.TEXT_NODE:
                out_stream.write(child_tag.data)
            elif child_tag.nodeType == child_tag.ELEMENT_NODE:
                if child_tag.nodeName.find(":") > 0:
                    new_tag = self.new_instance_for_elememt(child_tag)
                    new_tag.get_html(out_stream)
                else:
                    out_stream.write("<%s " % child_tag.nodeName)
                    for (attribute_name, attribute_value) in child_tag.attributes.items():
                        out_stream.write("""%s="%s" """ % (attribute_name,attribute_value))
                    if len(child_tag.childNodes) == 0:
                        out_stream.write("/>")
                        continue
                    
                    out_stream.write(">")
                    for other_child_tag in child_tag.childNodes:
                        self.render_sub_tag(other_child_tag, out_stream)
                    out_stream.write("</%s>" % child_tag.nodeName)
                    
            elif child_tag.nodeType == child_tag.COMMENT_NODE:
                out_stream.write("<!--%s-->" % child_tag.data)
                
            else:
                out_stream.write("NODE NOT RENDERED: %s" % child_tag.nodeType)
                #print child_tag.__class__
                #print child_tag.nodeType
                #print "-----------------------------------"
        
    def do_body(self, out_stream):
        origin = 0
        regexp = re.compile("(<[\w]+:.+[^(><.)]+>)")
        for match in re.finditer(regexp, self.inner_html):
            (start, tag_stop) = match.span()
            if tag_stop < origin:
                continue
            #print content[start:tag_stop]
            out_stream.write(self.inner_html[origin:start])
            tag_content = self.inner_html[start:tag_stop]
            tag_lib = tag_content[1:tag_content.find(":")]
            reg_tag = re.search(":([\w]+|[\-])+", tag_content)
            (tag_name_start, tag_name_stop) = reg_tag.span()
            tag_name = tag_content[tag_name_start+1:tag_name_stop]
            tag_only = tag_content
            if self.inner_html[tag_stop-2] == "/":
                stop = tag_stop
            else:
                end_of_tag = "</%s:%s>" % (tag_lib,tag_name)
                tag_only += end_of_tag
                index = self.inner_html[tag_stop-1:].find(end_of_tag)
                if index == -1:
                    print "Can not find end of tag %s" % tag_content
                    print self.inner_html
                    continue
                stop = tag_stop + index + len(end_of_tag)
            new_tag = self.create_sub_tag(tag_only, self.inner_html[start:stop])
            if new_tag is None:
                out_stream.write("No class found for tag '%s'." % tag_only)
            else:
                new_tag.get_html(out_stream)
            origin = stop
        out_stream.write(self.inner_html[origin:])
        return self.SKIP_BODY

    def create_sub_tag(self, prototype, content):
        document = parseString(prototype)
        new_tag = self.new_instance_for_elememt(document.firstChild)
        if new_tag is None:
            return None
        start = content.find(">") + 1
        stop = content.rfind("<")
        new_tag.inner_html = content[start:stop]
        return new_tag
    
    def do_after_body(self, out_stream):
        #out_stream.write("<!-- %s.do_after_body -->\n" %  self.__class__)
        return self.SKIP_BODY

    def do_end_tag(self, out_stream):
        #out_stream.write("<!-- %s.do_end_tag -->\n" %  self.__class__)
        return self.SKIP_BODY


class IfPresent(Tag):
    def do_start_tag(self, out_stream):
        if not self.page_context.session.has_attribute(self.attributes["beanId"]):
            return self.SKIP_BODY
        else:
            return Tag.do_start_tag(self, out_stream)

class IfNotPresent(Tag):
    def do_start_tag(self, out_stream):
        if self.page_context.session.has_attribute(self.attributes["beanId"]):
            return self.SKIP_BODY
        else:
            return Tag.do_start_tag(self, out_stream)

class Error(Tag):

    def do_start_tag(self, out_stream):
        error_name = self.attributes["name"]
        if self.page_context.errors.has_key(error_name):
            out_stream.write("""<span class="error">%s</span><br>""" % self.page_context.errors[error_name])
        return self.SKIP_BODY


class XmlError(Tag):

    def do_start_tag(self, out_stream):
        error_name = self.attributes["name"]
        if self.page_context.errors.has_key(error_name):
            out_stream.write("""<span class="error">%s in %s</span><br>""" % (self.page_context.errors[error_name], self.page_context.parameters))
        return self.SKIP_BODY

class MetaLib(Tag):

    def get_html(self, out_stream):
        if not self.page_context.session.has_attribute(self.attributes["beanId"]):
            out_stream.write("Bean with id '%s' not found." % self.attributes["beanId"])
            out_stream.write("%s" % self.page_context.session)
            return

        self.metalib = self.page_context.session.get_attribute(self.attributes["beanId"])
        self.all_ids = self.metalib.medias.keys()
        Tag.get_html(self, out_stream)


    def do_start_tag(self, out_stream):
        self.table_id = "%s_%s" % (self.attributes["tableIdPrefix"], self.attributes["order"])
        destination_input_id = "%s_%s" % (self.attributes["destinationInput"], self.attributes["order"])
        value = """<table class="%s" id="%s">\n""" % (self.attributes["cssClass"], self.table_id)

        if self.attributes["withHeaders"] == "yes":
            value += """\t<tr class="definition">\n"""
            for data_key in self.metalib.definition.data_order:
                data_definition = self.metalib.definition.data_definitions[data_key]
                if data_key == self.metalib.definition.key:
                    value += """\t\t<th class="data_definition" is_key="yes">%s</th>\n""" % data_definition.display
                else:
                    value += """\t\t<th class="data_definition" is_key="no">%s</th>\n""" % data_definition.display
            value += """\t</tr>\n"""

        out_stream.write(value)
        self.media_order = 0
        if self.media_order < len(self.all_ids) :
            self.page_context.session.set_attribute(self.attributes["mediaId"], self.metalib.medias[self.all_ids[self.media_order]] )
            return self.EVAL_BODY_INCLUDE
        else:
            return self.SKIP_BODY
        

    def do_after_body(self, out_stream):
        self.media_order += 1
        if self.media_order < len(self.all_ids) :
            self.page_context.session.set_attribute(self.attributes["mediaId"], self.metalib.medias[self.all_ids[self.media_order]] )
            return self.EVAL_BODY_AGAIN
        else:
            return self.SKIP_BODY


    def do_end_tag(self, out_stream):
        out_stream.write("</table>\n")
        if self.attributes["selection"] != "":
            out_stream.write("""<script language="javascript">
document.getElementById("choice_%(order)s").value = "%(selection)s";
update_selection("%(tableIdPrefix)s_%(order)s","choice_%(order)s");
</script>""" % self.attributes)

        return self.SKIP_BODY



class MediaSelect(Tag):

    def do_body(self, out_stream):
        current_media = self.page_context.session.get_attribute(self.attributes["mediaId"])
        order = self.parent.media_order
        destination_input_id = self.parent.attributes["destinationInput"]
        table_id = self.parent.table_id
        row_id = "%s_%s" % (table_id, order)
        value = """\t<tr class='media' id='%(row_id)s' key="%(key)s" onclick='select_unique_row("%(table_id)s","%(key)s","%(input_id)s")'>\n""" % {"key":current_media.key_value, "row_id":row_id, "input_id":destination_input_id, "table_id":table_id}
        for data_name in current_media.definition.data_order:
            data_object = current_media.data[data_name]
            is_key = "no"
            if data_name == current_media.definition.key:
                is_key = "yes"

            value += "\t\t<td class='data' is_key='%s'>%s</td>\n" % (is_key, data_object.value)
        value += "\t</tr>\n"
        out_stream.write(value)
        
        return Tag.do_body(self, out_stream)


class MetaLibEdit(Tag):

    def do_start_tag(self, out_stream):
        out_stream.write("""<table class="%s">\n""" % self.attributes["cssClass"])
        self.definition = self.page_context.session.get_attribute( self.attributes["definitionBeanId"] )
        self.media = None
        if self.attributes.has_key("mediaId") and (self.attributes["mediaId"] != "") :
            self.media = self.page_context.session.get_attribute( self.attributes["mediaId"] )
        self.data_counter = 0
        if self.data_counter < len(self.definition.data_order) :
            data_name = self.definition.data_order[self.data_counter]
            self.current_definition = self.definition.data_definitions[data_name]
            return self.EVAL_BODY_INCLUDE
        else:
            return self.SKIP_BODY

    def do_after_body(self, out_stream):
        self.data_counter += 1
        if self.data_counter < len(self.definition.data_order) :
            data_name = self.definition.data_order[self.data_counter]
            self.current_definition = self.definition.data_definitions[data_name]
            return self.EVAL_BODY_AGAIN
        else:
            return self.SKIP_BODY


    def do_end_tag(self, out_stream):
        out_stream.write("</table>\n")
        return self.SKIP_BODY

class DataEdit(Tag):

    def get_html(self, out_stream):
        self.data_definition = self.parent.current_definition
        self.media = self.parent.media
        Tag.get_html(self, out_stream)

    def do_start_tag(self, out_stream):
        is_key = "no"
        cellCssClass = self.attributes["cssClassForText"]
        if self.parent.definition.key == self.data_definition.id:
            is_key = "yes"
            cellCssClass = self.attributes["cssClassForKey"]
            
        out_stream.write("""<tr class="%s" is_key="%s" title="%s">""" % (self.attributes["cssClassForRow"], is_key, self.data_definition.comment))
        out_stream.write("""<td class="%s">%s</td>""" % (cellCssClass, self.data_definition.display))
        
    def do_body(self, out_stream):
        out_stream.write("""<td class="%s">""" % self.attributes["cssClassForValue"])
        is_key = (self.parent.definition.key == self.data_definition.id)
        if self.parent.current_definition.type == "LABEL":
            if self.media is None:
                out_stream.write("""<input class="label" type="text" name="%s">""" % self.data_definition.id)
            else:
                if is_key:
                    out_stream.write("""<input type="hidden" name="%(name)s" value="%(value)s">%(value)s""" % {"name":self.data_definition.id, "value":self.media.data[self.data_definition.id].value})
                else:
                    out_stream.write("""<input class="label" type="text" name="%s" value="%s">""" % (self.data_definition.id, self.media.data[self.data_definition.id].value))
        elif self.parent.current_definition.type == "TEXT":
            if self.media is None:
                out_stream.write("""<textarea class="text" name="%s"></textarea>""" % self.data_definition.id)
            else:
                if is_key:
                    out_stream.write("""<input type="hidden" name="%s"><pre>%s</pre>""" % (self.data_definition.id, self.media.data[self.data_definition.id].value))
                else:
                    out_stream.write("""<textarea class="text" name="%s">%s</textarea>""" % (self.data_definition.id, self.media.data[self.data_definition.id].value))
        elif self.parent.current_definition.type == "METALIB":
            order = self.parent.data_counter
            out_stream.write("""<input type="hidden" name="%(name)s" id="choice_%(order)s" value="" onchange="selection_changed('metalib_%(order)s','choice_%(order)s')">""" % {"order":order, "name": self.data_definition.id})

            xml_string = ""
            if self.media is None:
                xml_string = """
<psp:metalib-select tableIdPrefix="metalib" beanId="metalib" mediaId="current_media" order="%(order)s" destinationInput="choice_%(order)s" withHeaders="yes"> 
  <psp:media-select mediaId="current_media">
  </psp:media-select>
</psp:metalib-select>""" % {"order":order}
            else:
                xml_string = """
<psp:metalib-select tableIdPrefix="metalib" beanId="metalib" mediaId="current_media" order="%(order)s" destinationInput="choice_%(order)s" withHeaders="yes" selection="%(selection)s"> 
  <psp:media-select mediaId="current_media">
  </psp:media-select>
</psp:metalib-select>""" % {"order":order, "selection":self.media.data[self.parent.current_definition.id].value}
            document = parseString(xml_string)
            element = document.firstChild
            tag_for_metalib = self.new_instance_for_elememt(element)
            tag_for_metalib.page_context.add_bean("metalib", self.data_definition.metalib)
            tag_for_metalib.get_html(out_stream)
        else:
            out_stream.write(self.data_definition)
        out_stream.write("""</td>""")
        return self.SKIP_BODY

    def do_end_tag(self, out_stream):
        out_stream.write("</tr>\n")
        return self.SKIP_BODY

