#!/usr/bin/env python

from xml.dom.minidom import parseString
from codecs import getreader
import new, re

from taglib import Tag

class Forward:
    def __init__(self):
        self.page_context = PageContext()

class ActionForward(Forward):
    def __init__(self, action_class, form_class):
        Forward.__init__(self)
        self.action = action_class
        self.form = form_class


class PathForward(Forward):
    def __init__(self, path_to_file):
        Forward.__init__(self)
        self.page = path_to_file

    def print_to(self, print_stream, tag_mapping, session):
        file_stream = open(self.page)
        content = file_stream.read()
        file_stream.close()
        self.page_context.taglib = tag_mapping
        self.page_context.session = session
        self.render_page(content, print_stream)
        
        
    def render_page(self, content, out_stream):
        empty_tag = Tag(None)
        empty_tag.page_context = self.page_context
        empty_tag.inner_html = content
        empty_tag.get_html(out_stream)
        return


class ActionMapping:
    def __init__(self):
        self.mapping = {}
    
    def add_action(self, key, action_class, form_class):
        self.mapping[key] = ActionForward(action_class, form_class)

    def add_path(self, key, path):
        self.mapping[key] = PathForward(path)

    def find_forward(self, key):
        if self.mapping.has_key(key):
            return self.mapping[key]
        else:
            return None

class ServerContext:
    def __init__(self):
        self.common_data = {}
        self.clients_data = {}
        self.client_ip = None

    def set_client_ip(self, tuple):
        self.client_ip = tuple[0]

    def get_data(self, identifier):
        if not self.common_data.has_key(identifier):
            return None
        return self.common_data[identifier]

    def add_data(self, identifier, object):
        self.common_data[identifier] = object

    def get_client_data(self, identifier):
        if not self.clients_data.has_key(self.client_ip):
            return None
        client_data = self.clients_data[self.client_ip]
        if not client_data.has_key(identifier):
            return None
        return client_data[identifier]

    def add_client_data(self, identifier, object):
        if not self.clients_data.has_key(self.client_ip):
            self.clients_data[self.client_ip] = {}
        self.clients_data[self.client_ip][identifier] = object


class PageContext:
    def __init__(self):
        self.errors = {}
        self.taglibs = None
        self.path = None
        self.session = None
        self.parameters = None

    def add_error(self, message_key, next_message):
        self.errors[message_key] = next_message

    def add_bean(self, key, object):
        self.session.set_attribute(key, object)

    def __str__(self):
        val = "PageContext: \n  errors: %s\n" % self.errors
        val += "  beans: %s" % self.beans 
        return val

class MessagePage:
    def __init__(self, template_page):
        self.page = template_page
        self.errors = {}
        self.beans = {}

    def add_error(self, message_key, next_message):
        self.errors[message_key] = next_message
        

    def add_bean(self, key, object):
        self.beans[key] = object

    def has_errors(self):
        for error_message in self.errors.values():
            if error_message is not None:
                return True
        return False

    def print_to(self, print_stream):
        template_page = open(self.page)
        content = template_page.read()
        template_page.close()
        new_content = ""
        
        index_start = content.find("<psp:")
        while index_start > -1:
            new_content += content[:index_start]
            index_stop = content.find(">",index_start)
            if content[index_stop-1] != "/":
                index_stop = content.find("</psp",index_start)
                index_stop = content.find(">",index_stop)+1
            else:
                index_stop = index_stop+1

            # insert interpreted code
            parsable_content = content[index_start:index_stop]
            new_content_part = self.read_tag(parsable_content)
            new_content += new_content_part
            
            index_start = content.find("<psp:",index_stop)
            if index_start > 0:
                new_content += content[index_stop+1:index_start]
            else:
                new_content += content[index_stop+1:]

        print_stream.write(new_content)

    def print_items_to(self, print_stream, full_dict):
        print "print_items_to : USED"
        template_page = open(self.page)
        content = template_page.read()
        template_page.close()

        index_start = content.find("<templates>")
        index_stop = content.find("</templates>",index_start)
        if (index_start != -1) and (index_stop != -1):
            content_tmp = content[:index_start] + content[index_stop+12:]
            content = content_tmp
        
        for (search, replace) in full_dict.items():
            if replace is None:
                replace = ''
            indexOfFindString = content.find(search)
            newContent = ""
            currentPosition = 0
            while indexOfFindString > -1:
                newContent += content[currentPosition:indexOfFindString] + replace
                currentPosition = indexOfFindString + len(search)
                indexOfFindString = content.find(search,currentPosition)
            newContent += content[currentPosition:]
            content = newContent
            
        print_stream.write(content)
        
        