#!/usr/bin/env python
# Web server
from BaseHTTPServer import HTTPServer
from SimpleHTTPServer import SimpleHTTPRequestHandler
from xml.dom.ext.reader.Sax import FromXmlFile

import select, cgi

import os, cgi, urllib
import random, string, StringIO, Cookie
import imp, inspect, new, sys

# Web actions
from abstractAction import *
from pageManagement import *


from taglib import Tag_definition, Tag, Tag_attribute

ACTION_SUFFIX='.do'
ACTION_PREFIX='/'
ERROR_PAGE_TEMPLATE='templates/error.tpl'
STANDARD_PAGE_TEMPLATE='templates/standard.tpl'

def generateRandom(length):
    """Return a random string of specified length (used for session id's)"""
    return ''.join([random.choice(string.ascii_letters + string.digits) for i in range(length)])

class SessionElement:
    def __init__(self):
        self.attributes = {}

    def get_attribute(self, key):
        if self.has_attribute(key):
            return self.attributes[key]
        else:
            return None

    def set_attribute(self, key, value):
        self.attributes[key] = value
    
    def has_attribute(self, key):
        return self.attributes.has_key(key)


class HTTPHandler (SimpleHTTPRequestHandler):
    server_version = "SimpleHttpServer HTTP/1.1"

    def __init__(self, request, client_address, server):
        SimpleHTTPRequestHandler.__init__(self, request, client_address, server)

    def do_GET(self):
        body = {}
        if self.path.find('?') > -1:
            qs = self.path.split('?',1)[1]
            body = cgi.parse_qs(qs, keep_blank_values=1)
        if self.path == "/":
            self.path = "/%s/index.html" % (self.server.html_root)
        else:
            self.path = "/%s%s" % (self.server.html_root, self.path)
        self.handle_data(body)

    def do_POST(self):
        """Begin serving a POST request. The request data is readable
        on a file-like object called self.rfile"""
        ctype, pdict = cgi.parse_header(self.headers.getheader('content-type'))
        length = int(self.headers.getheader('content-length'))
        if ctype == 'multipart/form-data':
            body = cgi.parse_multipart(self.rfile, pdict)
        elif ctype == 'application/x-www-form-urlencoded':
            qs = self.rfile.read(length)
            body = cgi.parse_qs(qs, keep_blank_values=1)
        else:
            body = {}  # Unknown content-type
        # some browsers send 2 more bytes...
        [ready_to_read,x,y] = select.select([self.connection],[],[],0)
        if ready_to_read:
            self.rfile.read(2)
        self.handle_data(body)
        
        
    def handle_data(self, parameters):
        infile = StringIO.StringIO()
        self.cookie = self.get_cookie()
        session = self.get_session(self.cookie)
        extension = self.path[:self.path.rfind(".")]
        self.resp_headers = {}
        if not self.path.endswith(ACTION_SUFFIX):
            ctype = self.guess_type(self.path)
            if ctype.startswith('text/'):
                mode = 'r'
            else:
                mode = 'rb'
            try:
                path = self.translate_path(self.path)
                f = open(path,mode)
                self.resp_headers['Content-type'] = ctype
                self.resp_headers['Content-length'] = str(os.fstat(f.fileno())[6])
                self.done(200,f)
            except IOError:
                self.error("File <%s> not found" % self.path)
                #self.send_error(404, "File not found")
        else:
            uri = self.path[self.path.rfind(ACTION_PREFIX)+len(ACTION_PREFIX):self.path.rfind(ACTION_SUFFIX)]
            self.resp_headers["Content-type"] = "text/html"
            self.do_action(uri, infile, session, parameters)
            self.done(200,infile)
                    

    def done(self, code, infile):
        """Send response, cookies, response headers 
        and the data read from infile"""
        self.send_response(code)
        for a_cookie in self.cookie.values():
            self.send_header('Set-Cookie', a_cookie.output(header='').lstrip())
        for (key, value) in self.resp_headers.items():
            self.send_header(key, value)

        self.end_headers()
        infile.seek(0)
        self.copyfile(infile, self.wfile)

    def get_cookie(self):
        if self.headers.has_key('cookie'):
            return Cookie.SimpleCookie(self.headers.getheader("cookie"))
        else:
            return Cookie.SimpleCookie()

    def get_session(self, cookie):
        """Acces a la session du client. Si pas present, creation d'un nouvel objet.
        """
        if cookie.has_key("sessionId"):
            sessionId = cookie["sessionId"].value
        else:
            sessionId = generateRandom(8)
            cookie["sessionId"] = sessionId

        try:
            sessionObject = self.server.session_dict[sessionId]
        except KeyError:
            sessionObject = SessionElement()
            self.server.session_dict[sessionId] = sessionObject
        return sessionObject

    def do_action(self, path_action, out_stream, session, parameters):
        """Execution d'une action
        """
        self.info('Action : <%s>' % path_action )
        result = None

        # find action
        action_forward = self.server.action_mapping.find_forward(path_action)
        if action_forward is None:
            self.error("URI '%s' has no action" % path_action)
            self.display_error_page("URI '%s' has no action" % path_action )
            return
        
        result = None
        if isinstance(action_forward, ActionForward):

            class_action = action_forward.action
            form_class = action_forward.form
            form_instance = new.instance(form_class)
            form_instance.__init__()
            form_instance.validate(parameters, session)
            
            action_instance = new.instance(class_action)
            action_instance.__init__()
            action_instance.path = path_action
            result = action_instance.execute_action(form_instance, self.server.action_mapping, session)
            result.page_context.errors.update(form_instance.errors)
            result.page_context.parameters = parameters

        if isinstance(action_forward, PathForward):
            self.warn("minimal.py - line 90 : not yet !")
            
        # interpret result
        if result is None:
            self.display_error_page( '<pre>Action returned None.</pre>' )
            return
        
        if not isinstance(result, Forward):
            self.display_error_page( '<pre>Action did NOT return a Forward object.</pre>' )
            return

        if isinstance(result, ActionForward):
            self.error("ActionForward found. May not be possible...")
            # action appelle une action : pas de validation du form ? valeur des parametres ?
            return

        if isinstance(result, PathForward) :
            result.print_to(out_stream, self.server.taglibs, session)
            return
        
        print result
        self.display_error_page('<pre>Action returned an unkown object.</pre>')


    def info(self, message):
        print "[I]  %s" % message

    def error(self, message):
        print "[E] %s" % message

    def warn(self, message):
        print "[W] %s" % message
    
    def extract_parameters(self):    
        ctype, pdict = cgi.parse_header(self.headers.getheader('content-type'))
        length = int(self.headers.getheader('content-length'))
        if ctype == 'multipart/form-data':
            values = cgi.parse_multipart(self.rfile, pdict)
        elif ctype == 'application/x-www-form-urlencoded':
            qs = self.rfile.read(length)
            values = cgi.parse_qs(qs, keep_blank_values=1)
        else:
            values = {}                   # Unknown content-type
        # some browsers send 2 more bytes...
        [ready_to_read,x,y] = select.select([self.connection],[],[],0)
        if ready_to_read:
            self.rfile.read(2)
        return values

    def display_error_page(self, error):
        self.error(error)
        #if error.__class__ is type('srt') :
        #    self.display_page(ERROR_PAGE_TEMPLATE,[{'##message##': error}])
        #    return
            
        #if error.__class__ == ErrorMessages :
        #    full_message = ""
        #    for message in error.messages:
        #        full_message += "%s <br>" % message
        #    self.display_page(ERROR_PAGE_TEMPLATE,[{'##message##': full_message}])
        #    return
    
    def display_standard_page(self, message):
        self.display_page(STANDARD_PAGE_TEMPLATE,message)
    
    def display_page(self, page_filename, message):
        # read template
        template_page = open(page_filename)
        content = template_page.read()
        template_page.close()
        for (search, replace) in message.items():
            indexOfFindString = content.find(search)
            newContent = ""
            currentPosition = 0
            while indexOfFindString > -1:
                newContent += content[currentPosition:indexOfFindString] + replace
                currentPosition = indexOfFindString + len(search)
                indexOfFindString = content.find(search,currentPosition)
            newContent += content[currentPosition:]
            content = newContent
            
        self.wfile.write(content)


class MyHTTPServer(HTTPServer):
    def __init__(self, server_name, port):
        HTTPServer.__init__(self, (server_name, port), HTTPHandler)

        self.action_mapping = ActionMapping()
        self.initializer_action = None
        self.html_root = ""
        self.taglibs = {}
        self.context = ServerContext()
        self.session_dict = {}

        self.read_config("config/web.xml")
        
        # initialize with a specific action
        if self.initializer_action is not None:
            initializer_instance = new.instance(self.initializer_action)
            initializer_instance.__init__(self.context)

        
    def error(self, message):
        print "[E] %s" % message


    def read_config(self, xml_config):
        try:
            document = FromXmlFile(xml_config)
        except StandardError, reason:
            print reason
            self.error("File '%s' is invalid : %s" % (xml_config, reason))
            return 

        if len(document.getElementsByTagName("server-config")) != 1:
            self.error("File '%s' is invalid : tag <server-config> is not present or not unique." % xml_config)
            return
        config_tag = document.getElementsByTagName("server-config")[0]

        # reading html root directory
        if len(document.getElementsByTagName("html-root")) == 1:
            html_root_tag = document.getElementsByTagName("html-root")[0]
            path_to_html_root = html_root_tag.getAttribute("relative-path")
            self.html_root = path_to_html_root

        # reading action definition
        if len(document.getElementsByTagName("actions")) != 1:
            self.error("File '%s' is invalid : tag <actions> is not present or not unique." % xml_config)
            return
        action_tag = document.getElementsByTagName("actions")[0]
        action_config_file = action_tag.getAttribute("config-file")
        if action_config_file == "":
            self.error("File '%s' is invalid : tag <actions> requires a non empty attribute 'config_file'." % xml_config)
            return
            
        self.read_action_definitions(action_config_file)

        # reading taglib definition
        if len(document.getElementsByTagName("taglibs")) != 1:
            self.error("File '%s' is invalid : tag <taglibs> is not present or not unique." % xml_config)
            return
        taglibs_tag = document.getElementsByTagName("taglibs")[0]
        for taglib_tag in taglibs_tag.getElementsByTagName("taglib"):
            prefix = taglib_tag.getAttribute("prefix")
            definition_file = taglib_tag.getAttribute("definition")
            self.read_taglib_definition(prefix, definition_file)

    def read_action_definitions(self, xml_config):
        try:
            document = FromXmlFile(xml_config)
        except StandardError, reason:
            print reason
            self.error("File '%s' is invalid : %s" % (xml_config, reason))
            return 

        if len(document.getElementsByTagName("config")) != 1:
            self.error("File '%s' is invalid : tag <config> is not present or not unique." % xml_config)
            return
        config_tag = document.getElementsByTagName("config")[0]
        
        if len(config_tag.getElementsByTagName("imports")) != 1:
            self.error("File '%s' is invalid : tag <imports> is not present or not unique." % xml_config)
            return
        import_tag = config_tag.getElementsByTagName("imports")[0]

        definitions = {"AbstractForm" : AbstractForm}

        for package_tag in import_tag.getElementsByTagName("package"):
            package_name = package_tag.getAttribute("name")
            
            if package_name == "":
                self.error("File '%s' is invalid : tag <package> requires a non empty attribute 'name'." % xml_config)
                return

            all_actions = package_tag.getAttribute("actions")
            all_forms = package_tag.getAttribute("forms")
            try:
                module = __import__(package_name, globals(), locals(), "*")
            except ImportError, reason:
                self.error("Unable to load package '%s'" % package_name)
                continue
            for action_class_name in all_actions.split(","):
                action_class_name = action_class_name.strip()
                if action_class_name == "":
                    continue
                action_class = getattr(module, action_class_name)
                if issubclass(action_class, AbstractAction):
                    if definitions.has_key(action_class_name):
                        self.error("Action class '%s' already defined in tag <package> in file '%s'." % (form_class_name, xml_config) )
                        print definitions.keys()
                        continue
                    definitions[action_class_name] = action_class
                else:
                    self.error("Class %s is not subclass of AbstractAction." % action_classname)

            for form_class_name in all_forms.split(","):
                form_class_name = form_class_name.strip()
                if form_class_name == "":
                    continue
                form_class = getattr(module, form_class_name)
                if issubclass(form_class, AbstractForm):
                    if definitions.has_key(form_class_name):
                        self.error("Form class '%s' already defined in tag <package> in file '%s'." % (form_class_name, xml_config) )
                        continue
                    definitions[form_class_name] = form_class
                else:
                    self.error("Class %s is not subclass of AbstractForm." % form_classname)


        if len(config_tag.getElementsByTagName("initAction")) != 1:
            self.error("File '%s' is invalid : tag <initAction> is not present or not unique." % xml_config)
            return
        initialize_tag = config_tag.getElementsByTagName("initAction")[0]
        package_name = initialize_tag.getAttribute("package")
        class_name = initialize_tag.getAttribute("name")

        try:
            module = __import__(package_name, globals(), locals(), "*")
            self.initializer_action = getattr(module, class_name)
        except ImportError:
            self.error("Unable to load package'%s'" % package_name)


        ## READING <mappings>
        if len(config_tag.getElementsByTagName("mappings")) != 1:
            self.error("File '%s' is invalid : tag <mappings> is not present or not unique." % xml_config)
            return
        
        for mapping_tag in config_tag.getElementsByTagName("mappings")[0].getElementsByTagName("mapping"):
            action_class_name = mapping_tag.getAttribute("action")
            form_class_name = mapping_tag.getAttribute("form")
            uri = mapping_tag.getAttribute("uri")
            if action_class_name == "":
                self.error("File '%s' is invalid : tag <mapping> requires a non empty attribute 'action'." % xml_config)
                continue
            if form_class_name == "":
                form_class_name = "AbstractForm"
            if uri == "":
                self.error("File '%s' is invalid : tag <mapping> requires a non empty attribute 'uri'." % xml_config)
                continue
            if not definitions.has_key(action_class_name):
                self.error("File '%s' is invalid : class '%s' not found in <import> 'uri'." % (xml_config, action_class_name))
                continue
            if not definitions.has_key(form_class_name):
                self.error("File '%s' is invalid : class '%s' not found in <import> 'uri'." % (xml_config, form_class_name))
                continue
                
            self.action_mapping.add_action(uri, definitions[action_class_name], definitions[form_class_name])

        if len(config_tag.getElementsByTagName("forwards")) == 0:
            return

        if len(config_tag.getElementsByTagName("forwards")) > 1:
                self.error("File '%s' is invalid : tag <formwards> is not unique." % xml_config)
        
        forwards = {}
        for forward_tag in config_tag.getElementsByTagName("forwards")[0].getElementsByTagName("forward"):
            forward_name = forward_tag.getAttribute("name")
            forward_path = forward_tag.getAttribute("path")
            if forward_name == "" :
                self.error("File '%s' is invalid : tag <forward> requires a non empty attribute 'name'." % xml_config)
                continue
            if forward_path == "" :
                self.error("File '%s' is invalid : tag <forward> requires a non empty attribute 'path'." % xml_config)
                continue

            if self.action_mapping.find_forward(forward_name) is None :
                self.action_mapping.add_path(forward_name, forward_path)
            else:
                self.error("File '%s' - Tag <forward> is invalid : name '%s' is already taken by action-mapping uri or forward name." % (xml_config, forward_name))
                continue



    def read_taglib_definition(self, prefix, xml_config):
        try:
            document = FromXmlFile(xml_config)
        except StandardError, reason:
            print reason
            self.error("File '%s' is invalid : %s" % (xml_config, reason))
            return 
        
        if len(document.getElementsByTagName("taglib")) != 1:
            self.error("File '%s' is invalid : tag <taglib> is not present or not unique." % xml_config)
            return
        all_tags = {}
        taglib_tag = document.getElementsByTagName("taglib")[0]
        for tagdef_tag in taglib_tag.getElementsByTagName("tag"):
            tag_name = tagdef_tag.getAttribute("name")
            full_name = tagdef_tag.getAttribute("class")
            package_name = full_name[:full_name.rfind('.')]
            class_name = full_name[full_name.rfind('.')+1:]
            try:
                module = __import__(package_name, globals(), locals(), "*")
            except ImportError, reason:
                self.error("Unable to load package '%s'" % package_name)
                continue
            py_class = getattr(module, class_name)
            if not issubclass(py_class, Tag):
                self.error("Class <%s> is not subclass of <Tag>" % class_name)
                continue
            all_attributes = {}
            for attribute_tag in tagdef_tag.getElementsByTagName("attribute"):
                attribute_name = attribute_tag.getAttribute("name")
                attribute_required = attribute_tag.getAttribute("required")
                attribute = Tag_attribute(attribute_name, attribute_required)
                check_condition = attribute_tag.getAttribute("match")
                if check_condition != "":
                    attribute.check = check_condition
                all_attributes[attribute_name] = attribute
            tag_definition = Tag_definition(tag_name, py_class)
            tag_definition.attributes = all_attributes
            all_tags[tag_name] = tag_definition

        self.taglibs[prefix] = all_tags


