import new

from pageManagement import *


class AbstractAction:
    
    def __init__(self):
        self.path = ""

    # Action execution with parameters
    def execute_action(self, form, mapping, server_context):
        # execute the action
        next_page = self.execute(form, mapping, server_context)
        return next_page

    def execute(self, form):
        return None


class AbstractForm:
    
    def __init__(self):
        self.errors = {}
    
    def add_error(self, key, message):
        self.errors[key] = message
        return self

    def has_errors(self):
        return len(self.errors) > 0

    def validate(self, parameters, server_context):
        return {}
        # when fails:
        # self.add_error("key A","Error Message 1").add_error("key B","Error Message 2")

