#!/usr/bin/env python

#from xmlStore import XmlReader

class MetaLib:
    def __init__(self, with_id = "", with_definition = None, with_medias = {}):
        self.definition = with_definition
        self.medias = with_medias
        self.id = with_id
        self.is_locked = False

    def add_media(self, a_media):
        self.medias[a_media.key_value] = a_media

    def __repr__(self):
        return "MetaLib(\"%s\",%s,%s)" % (self.id, self.definition, self.medias)

class Definition:
    def __init__(self, with_key = "", with_data_definitions = {}):
        self.key = with_key
        self.data_definitions = with_data_definitions # DataDefinition
        self.data_order = []

    def add_data_definition(self, a_dataDefinition):
        self.data_definitions[a_dataDefinition.id] = a_dataDefinition
        self.data_order.append(a_dataDefinition.id)
    
    def __repr__(self):
        return "Definition(\"%s\",%s)" % (self.key, self.data_definitions)
    
class DataDefinition:
    def __init__(self, with_id = "", with_type = None, with_display = "", with_comment = ""):
        self.id = with_id
        self.type = with_type
        self.display = with_display
        self.comment = with_comment
        self.type_separator = ":"

    def __repr__(self):
        return "DataDefinition(\"%s\",\"%s\",\"%s\",\"%s\")" % (self.id, self.type, self.display, self.comment)

    def compile(self):
        # try to change this object into a more finest subclass
        compiled_data_definition = None
        if (self.type.find(self.type_separator) > 0) and (self.type[:self.type.find(self.type_separator)].upper() == "METALIB"):
            # this is a SubMetaLib
            compiled_data_definition = SubMetaLib(self.id, self.type, self.display, self.comment)
        else:
            # this is a SimpleDataDefinition
            compiled_data_definition = SimpleDataDefinition(self.id, self.type.upper(), self.display, self.comment)
        return compiled_data_definition
        

class SimpleDataDefinition(DataDefinition):
    def __init__(self, with_id = "", with_type = None, with_display = "", with_comment = ""):
        DataDefinition.__init__(self, with_id, with_type, with_display, with_comment)
    
    def __repr__(self):
        return "SimpleDataDefinition(\"%s\",\"%s\",\"%s\",\"%s\")" % (self.id, self.type, self.display, self.comment)

    def is_simple(self):
        return True


class Label(SimpleDataDefinition):
    def __init__(self, with_id = "", with_display = "", with_comment = ""):
        SimpleDataDefinition.__init__(self, with_id, ("%s" % self.__class__), with_display, with_comment)

class Text(SimpleDataDefinition):
    def __init__(self, with_id = "", with_display = "", with_comment = ""):
        SimpleDataDefinition.__init__(self, with_id, ("%s" % self.__class__), with_display, with_comment)


class SubMetaLib(DataDefinition):
    def __init__(self, with_id = "", with_type = None, with_display = "", with_comment = ""):
        DataDefinition.__init__(self, with_id, with_type, with_display, with_comment)
        self.filename = self.type[self.type.find(self.type_separator)+1:]
        self.type = self.type[:self.type.find(self.type_separator)].upper()
        self.metalib = None

    def __repr__(self):
        return "SubMetaLib(\"%s\",\"%s\",\"%s\",\"%s\")" % (self.id, self.type, self.display, self.comment)

    def is_simple(self):
        return False
        
    def metalib_filename(self):
        return self.filename

class Media:
    def __init__(self, with_definition, with_data = {}):
        self.definition = with_definition
        self.data = with_data
        self.key_value = None
        
    def add_data(self, a_data):
        # get definition for this data
        if not self.definition.data_definitions.has_key(a_data.id):
            raise Exception("No definition for data [%s] in %s" % (a_data.id, self.definition.data_definitions))
            return
        self.data[a_data.id] = a_data
        if self.definition.key == a_data.id:
            self.key_value = a_data.value

    def __repr__(self):
        full_str = "Media(%s," % self.data
        #for a_data in self.data.values():
        #    full_str += "%s," % a_data
        full_str += "%s)" % (self.key_value)
        return full_str

class Data:
    def __init__(self, with_id = "", with_value = None, with_definition = None):
        self.id = with_id
        self.value = with_value
        self.definition = with_definition
        
    def __repr__(self):
        return "Data(\"%s\",\"%s\")" % (self.id, self.value)

