from server.abstractAction import *

from xmlStore import *

class LoadAction(AbstractAction):
    def execute(self, form, mapping, session):
        if form.has_errors():
            return mapping.find_forward("load_page")
        nextPage = mapping.find_forward("display_page")
        return nextPage
        
class LoadForm(AbstractForm):
    def validate(self, parameters, session):
        if len(parameters["current_metalib"]) == 0:
            self.add_error("error","Nothing to load")
        # load a metalib
        xml_content = parameters["current_metalib"][0]
        try:
            metalib = XmlReader("web").parse_string(xml_content)
            session.set_attribute("metalib", metalib)
        except Exception, reason:
            self.add_error("XML",reason)
