from objects import *

from server.abstractAction import *
from server.pageManagement import *

class EditAction(AbstractAction):

    def execute(self, form, mapping, server_context):
        if form.has_errors():
            nextPage = mapping.find_forward("editForm")
            return nextPage

        metalib = server_context.get_client_data("client_metalib")
        key_name = metalib.definition.key
        media_key_value = form.media_data[key_name]

        media = metalib.medias[media_key_value]
        for (data_name, data_value) in form.media_data.items():
            data_in_media = media.data[data_name]
            data_in_media.value = data_value
        return mapping.find_forward("display_page")

class EditForm(AbstractForm):
    
    def __init__(self):
        AbstractForm.__init__(self)
        self.media_data = {}
    
    def validate(self, parameters, server_context):
        metalib = server_context.get_client_data("client_metalib")
        key_id = metalib.definition.key
        
        if not metalib.medias.has_key(parameters[key_id]) :
            self.add_error("forms-errors", """Key "%s" not found""" % parameters[key_id])
            return
        for id in metalib.definition.data_order:
            self.media_data[id] = parameters[id]

