from server.abstractAction import *
from htmlStore import *

class DisplayAction(AbstractAction):
    def execute(self, form, mapping, server_context):
        nextPage = mapping.find_forward("display_page")
        print server_context.clients_data
        metalib = server_context.get_client_data("client_metalib")
        if metalib is None:
            nextPage.page_context.add_error("metalib-error", "No metalib loaded.")
        else:
            nextPage.page_context.add_bean("metalib", metalib)
        return nextPage


class DisplayCreationAction(AbstractAction):
    def execute(self, form, mapping, server_context):
        nextPage = mapping.find_forward("create_page")
        nextPage.page_context.add_bean("definition", server_context.get_client_data("client_metalib").definition)
        return nextPage


class DisplayEditionAction(AbstractAction):
    def execute(self, form, mapping, server_context):
        nextPage = mapping.find_forward("edit_page")
        metalib = server_context.get_client_data("client_metalib")
        media = metalib.medias[form.edit_key]
        nextPage.page_context.add_bean("definition", metalib.definition)
        nextPage.page_context.add_bean("media", media)
        return nextPage

class DisplayEditionForm(AbstractForm):
    def __init__(self):
        AbstractForm.__init__(self)
        self.edit_key = None

    def validate(self, parameters, server_context):
        if parameters["media_id"] == "":
            self.add_error("key_not_found", parameters["media_id"] )
        self.edit_key = parameters["media_id"]
        
        metalib = server_context.get_client_data("client_metalib")
        
        if not metalib.medias.has_key(self.edit_key):
            self.add_error("key_not_found", parameters["media_id"] )
