from objects import *

from server.abstractAction import *
from server.pageManagement import *

class DeleteAction(AbstractAction):
    
    def execute(self, form, mapping, server_context):
        metalib = server_context.get_client_data("client_metalib")
        nextPage = mapping.find_forward("display_page")

        if form.has_errors() or not metalib.medias.has_key(form.delete_key):
            nextPage.page_context.add_error("forms-errors",'Metalib does not contains media with key "%s".' % form.delete_key)
        else:
            del(metalib.medias[form.delete_key])

        return nextPage


class DeleteForm(AbstractForm):
    
    def __init__(self):
        AbstractForm.__init__(self)
        self.delete_key = None
        
    def validate(self, parameters, server_context):
        if parameters["media_id"] == "":
            self.add_error("key_not_found", parameters["media_id"] )

        self.delete_key = parameters["media_id"]
