from objects import *

from server.abstractAction import *
from server.pageManagement import *

class CreateAction(AbstractAction):
    
    def execute(self, form, mapping, server_context):
        if form.has_errors():
            nextPage = mapping.find_forward("create_page")
            nextPage.errors = form.errors
            return nextPage

        # cree un nouveau media
        metalib = server_context.get_client_data("client_metalib")
        media = Media(metalib.definition, with_data = {})
        # creation des donnees
        for (data_name, data_value) in form.media_data.items():
            data = Data(with_id = data_name, with_value = data_value)
            media.add_data(data)
        
        metalib.add_media(media)
        return mapping.find_forward("display_page")


class CreateForm(AbstractForm):
    
    def __init__(self):
        AbstractForm.__init__(self)
        self.media_data = {}
    
    def validate(self, parameters, server_context):
        metalib = server_context.get_client_data("client_metalib")
        key_id = metalib.definition.key

        if parameters[key_id] == "":
            self.add_error("forms-errors", """Key "%s" is empty""" % metalib.definition.data_definitions[key_id].display)
            return
        if metalib.medias.has_key(parameters[key_id]) :
            self.add_error("forms-errors", """Key "%s" already present""" % parameters[key_id])
            return
        self.media_data = parameters

        
        
        